/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component.custom;

import com.buuz135.industrial.api.conveyor.gui.PositionedGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public abstract class TexturedStateButtonGuiComponent
extends PositionedGuiComponent {
    private final int id;
    private StateButtonInfo[] buttonInfos;

    public TexturedStateButtonGuiComponent(int id, int x, int y, int xSize, int ySize, StateButtonInfo ... buttonInfos) {
        super(x, y, xSize, ySize);
        this.id = id;
        this.buttonInfos = new StateButtonInfo[0];
        if (buttonInfos != null) {
            this.buttonInfos = buttonInfos;
        }
    }

    @Override
    public boolean handleClick(AbstractContainerScreen conveyor, int guiX, int guiY, double mouseX, double mouseY) {
        if (conveyor instanceof ICanSendNetworkMessage) {
            ((ICanSendNetworkMessage)conveyor).sendMessage(this.id, new CompoundTag());
        }
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(SoundEvents.f_12490_, SoundSource.PLAYERS, 1.0f, 1.0f, Minecraft.m_91087_().f_91074_.m_142538_()));
        return true;
    }

    @Override
    public void drawGuiBackgroundLayer(PoseStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)buttonInfo.getTexture());
            Minecraft.m_91087_().f_91080_.m_93228_(stack, guiX + this.getXPos(), guiY + this.getYPos(), buttonInfo.getTextureX(), buttonInfo.getTextureY(), this.getXSize(), this.getYSize());
        }
    }

    @Override
    public void drawGuiForegroundLayer(PoseStack stack, int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null && this.isInside(mouseX, mouseY)) {
            GuiComponent.m_93172_((PoseStack)stack, (int)(this.getXPos() - guiX), (int)(this.getYPos() - guiY), (int)(this.getXPos() + this.getXSize() - guiX), (int)(this.getYPos() + this.getYSize() - guiY), (int)-2130706433);
        }
    }

    @Override
    @Nullable
    public List<Component> getTooltip(int guiX, int guiY, double mouseX, double mouseY) {
        StateButtonInfo buttonInfo = this.getStateInfo();
        if (buttonInfo != null) {
            return Arrays.asList(buttonInfo.getTooltip());
        }
        return null;
    }

    public abstract int getState();

    private StateButtonInfo getStateInfo() {
        for (StateButtonInfo buttonInfo : this.buttonInfos) {
            if (buttonInfo.getState() != this.getState()) continue;
            return buttonInfo;
        }
        return null;
    }
}

